import time
import random
import string
import urllib.parse
from selenium import webdriver
from selenium.webdriver.common.by import By
from selenium.webdriver.firefox.service import Service
from selenium.webdriver.support.ui import WebDriverWait
from selenium.webdriver.support import expected_conditions as EC
from webdriver_manager.firefox import GeckoDriverManager

# Função para gerar senha segura
def gerar_senha():
    while True:
        senha = ''.join(random.choices(string.ascii_letters + string.digits + "!@#$%^&*()_-+=", k=10))
        if (any(c.islower() for c in senha) and
            any(c.isupper() for c in senha) and
            any(c.isdigit() for c in senha) and
            any(c in "!@#$%^&*()_-+=" for c in senha)):
            return senha

# Criar o driver do Firefox
options = webdriver.FirefoxOptions()
service = Service(GeckoDriverManager().install())
driver = webdriver.Firefox(service=service, options=options)

# Abrir o site e aguardar login manual
driver.get('https://locaweb.com.br')
input("Faça login e pressione Enter para continuar...")

while True:
    # Apaga o conteúdo do arquivo antes de começar um novo ciclo
    open("logins_alterados.txt", "w").close()

    # Lendo e-mails do arquivo
    with open("lista_emails.txt", "r") as f:
        emails = [line.strip() for line in f if line.strip()]

    dominio_atual = None

    # Criar arquivo de logins alterados
    with open("logins_alterados.txt", "a") as arquivo_logins:
        for email in emails:
            dominio = email.split("@")[-1]
            email_encoded = urllib.parse.quote(email)
            url_busca = f"https://painel-email.locaweb.com.br/domains/{dominio}/mailboxes?search_params={email_encoded}&commit=Buscar"

            # Se o domínio mudou, carregar a nova página
            if dominio != dominio_atual:
                driver.get(url_busca)
                dominio_atual = dominio
            else:
                driver.execute_script(f"window.location.href = '{url_busca}';")

            # Esperar a página carregar
            try:
                WebDriverWait(driver, 10).until(
                    EC.presence_of_element_located((By.ID, "search_params"))
                )
            except:
                print(f"❌ Página não carregou corretamente para {email}")
                continue

            # Clicar no botão "Alterar senha"
            try:
                alterar_senha_btn = WebDriverWait(driver, 10).until(
                    EC.element_to_be_clickable((By.XPATH, f"//a[contains(@data-target, 'modal_change_pass')]"))
                )
                alterar_senha_btn.click()
                print(f"✔ Modal aberto para {email}")
            except Exception as e:
                print(f"❌ Erro ao tentar abrir o modal para {email}: {e}")
                continue

            # **Novo**: Esperar o modal estar visível
            time.sleep(2)  # Pequeno delay para evitar falha na detecção do modal

            # Gerar nova senha
            nova_senha = gerar_senha()

            # Preencher o campo de senha no modal
            try:
                campo_senha = WebDriverWait(driver, 10).until(
                    EC.presence_of_element_located((By.XPATH, "//input[contains(@class, 'new_password')]"))
                )
                
                # **Novo**: Garantir que o campo esteja visível
                driver.execute_script("arguments[0].scrollIntoView(true);", campo_senha)
                time.sleep(1)  # Aguardar a rolagem
                
                campo_senha.clear()
                campo_senha.send_keys(nova_senha)
            except Exception as e:
                print(f"❌ Erro ao preencher a senha para {email}: {e}")
                continue

            # Clicar no botão "Alterar senha"
            try:
                botao_alterar = WebDriverWait(driver, 10).until(
                    EC.element_to_be_clickable((By.XPATH, f"//button[contains(@id, 'submit_with_validation')]"))
                )
                botao_alterar.click()
                print(f"✔ Senha alterada para {email}: {nova_senha}")
            except Exception as e:
                print(f"❌ Erro ao confirmar a alteração da senha para {email}: {e}")
                continue

            # Salvar login alterado
            arquivo_logins.write(f"{email};{nova_senha}\n")

            # Pequeno delay entre as alterações
            time.sleep(10)

    # Opções após a execução
    escolha = input("\nPressione Enter para reiniciar ou digite 'sair' para encerrar: ").strip().lower()
    if escolha == "sair":
        print("Encerrando o processo...")
        driver.quit()
        break
